#include "file_hook.h"
#include "ccode.h"
#include <string>
#include <vector>
using namespace std;

vector<wstring> list;
wstring tmpPath;

wstring getEnvironmentVariable(const wstring& varName) {
    wchar_t buffer[512];
    DWORD length = GetEnvironmentVariableW(varName.c_str(), buffer, sizeof(buffer));
    if (length == 0) {
        return L"error";
    }
    return wstring(buffer, length);
}

void explainVariables() {
    wstring programFilesX86 = getEnvironmentVariable(L"ProgramFiles(x86)");
    wstring programFiles = getEnvironmentVariable(L"ProgramFiles");
    wstring programData = getEnvironmentVariable(L"ProgramData");
    wstring userProfile = getEnvironmentVariable(L"USERPROFILE");
    wstring publicFolder = getEnvironmentVariable(L"Public");
    tmpPath = getEnvironmentVariable(L"Temp");

    wstring publicDocumentsAdobeCodecs = publicFolder + L"\\Documents\\AdobeInstalledCodecsTier2";

    list.push_back(programFilesX86);
    list.push_back(programFiles);
    list.push_back(programData);
    list.push_back(userProfile);
    list.push_back(publicDocumentsAdobeCodecs);
}

wstring replacePrefixWithIndex(const wstring& s) {
    for (size_t i = 0; i < list.size(); ++i) {
        const auto& prefix = list[i];
        // sǰ׺ǷǵǰԪ
        if (s.rfind(prefix, 0) == 0)  // rfind(prefix, 0) Ƿǰ׺
            return tmpPath + L"\\" + to_wstring(i) + s.substr(prefix.length());
    }
    return s;  // ûƥǰ׺ԭַ
}

HANDLE WINAPI DT_CreateFileA(
    LPCSTR                lpFileName,
    DWORD                 dwDesiredAccess,
    DWORD                 dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD                 dwCreationDisposition,
    DWORD                 dwFlagsAndAttributes,
    HANDLE                hTemplateFile
)
{
    wstring str = replacePrefixWithIndex(to_wide_string(lpFileName));
    MessageBoxW(0, str.c_str(), L"", 0);
    if (str != L"error")
        return OG_CreateFileA(to_byte_string(str).c_str(),
            dwDesiredAccess,
            dwShareMode,
            lpSecurityAttributes,
            dwCreationDisposition,
            dwFlagsAndAttributes,
            hTemplateFile
        );
    return OG_CreateFileA(lpFileName,
        dwDesiredAccess,
        dwShareMode,
        lpSecurityAttributes,
        dwCreationDisposition,
        dwFlagsAndAttributes,
        hTemplateFile
    );
}

HANDLE WINAPI DT_CreateFileW(
    LPCWSTR                lpFileName,
    DWORD                 dwDesiredAccess,
    DWORD                 dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD                 dwCreationDisposition,
    DWORD                 dwFlagsAndAttributes,
    HANDLE                hTemplateFile
)
{
    wstring str = replacePrefixWithIndex(lpFileName);
    MessageBoxW(0, str.c_str(), L"", 0);
    if (str != L"error")
        return OG_CreateFileW(str.c_str(),
            dwDesiredAccess,
            dwShareMode,
            lpSecurityAttributes,
            dwCreationDisposition,
            dwFlagsAndAttributes,
            hTemplateFile
        );
    return OG_CreateFileW(lpFileName,
        dwDesiredAccess,
        dwShareMode,
        lpSecurityAttributes,
        dwCreationDisposition,
        dwFlagsAndAttributes,
        hTemplateFile
    );
}

HANDLE WINAPI DT_CreateFileTransactedA(
    LPCSTR                lpFileName,
    DWORD                 dwDesiredAccess,
    DWORD                 dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD                 dwCreationDisposition,
    DWORD                 dwFlagsAndAttributes,
    HANDLE                hTemplateFile,
    HANDLE                hTransaction,
    PUSHORT               pusMiniVersion,
    PVOID                 lpExtendedParameter
)
{
        return DT_CreateFileA(
           lpFileName,
           dwDesiredAccess,
           dwShareMode,
           lpSecurityAttributes,
           dwCreationDisposition,
           dwFlagsAndAttributes,
           hTemplateFile
        );
}

HANDLE WINAPI DT_CreateFileTransactedW(
    LPCWSTR                lpFileName,
    DWORD                 dwDesiredAccess,
    DWORD                 dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD                 dwCreationDisposition,
    DWORD                 dwFlagsAndAttributes,
    HANDLE                hTemplateFile,
    HANDLE                hTransaction,
    PUSHORT               pusMiniVersion,
    PVOID                 lpExtendedParameter
)
{
    return DT_CreateFileW(
        lpFileName,
        dwDesiredAccess,
        dwShareMode,
        lpSecurityAttributes,
        dwCreationDisposition,
        dwFlagsAndAttributes,
        hTemplateFile
    );
}