#include <Windows.h>

// MSVCwcscat
#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

// ȫԭʼversion.dll
static HMODULE hVersion;

// ȡַ
PVOID GetVersionFuncAddress(LPCSTR FuncName)
{
    if(!hVersion)
    {
        wchar_t systemDirectory[MAX_PATH];
        if (!::GetSystemDirectory(systemDirectory, MAX_PATH))
            return nullptr;
        wcscat(systemDirectory, L"\\System32\\version.dll");
        hVersion = ::LoadLibraryW(systemDirectory);
        if (!hVersion)
            return nullptr;
    }
    return GetProcAddress(hVersion, FuncName);
}

// 
#pragma comment(linker, "/EXPORT:GetFileVersionInfoA=P_GetFileVersionInfoA,@1")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoByHandle=P_GetFileVersionInfoByHandle,@2")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoExA=P_GetFileVersionInfoExA,@3")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoExW=P_GetFileVersionInfoExW,@4")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoSizeA=P_GetFileVersionInfoSizeA,@5")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoSizeExA=P_GetFileVersionInfoSizeExA,@6")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoSizeExW=P_GetFileVersionInfoSizeExW,@7")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoSizeW=P_GetFileVersionInfoSizeW,@8")
#pragma comment(linker, "/EXPORT:GetFileVersionInfoW=P_GetFileVersionInfoW,@9")
#pragma comment(linker, "/EXPORT:VerFindFileA=P_VerFindFileA,@10")
#pragma comment(linker, "/EXPORT:VerFindFileW=P_VerFindFileW,@11")
#pragma comment(linker, "/EXPORT:VerInstallFileA=P_VerInstallFileA,@12")
#pragma comment(linker, "/EXPORT:VerInstallFileW=P_VerInstallFileW,@13")
#pragma comment(linker, "/EXPORT:VerLanguageNameA=P_VerLanguageNameA,@14")
#pragma comment(linker, "/EXPORT:VerLanguageNameW=P_VerLanguageNameW,@15")
#pragma comment(linker, "/EXPORT:VerQueryValueA=P_VerQueryValueA,@16")
#pragma comment(linker, "/EXPORT:VerQueryValueW=P_VerQueryValueW,@17")


// ԭʼ
extern "C" BOOL P_GetFileVersionInfoA(
    LPCSTR lptstrFilename,
    DWORD dwHandle,
    DWORD dwLen,
    LPVOID lpData
) {
    BOOL(*pGetFileVersionInfoA)(LPCSTR, DWORD, DWORD, LPVOID) = (BOOL(*)(LPCSTR, DWORD, DWORD, LPVOID)) (GetVersionFuncAddress("GetFileVersionInfoA"));
    return pGetFileVersionInfoA(lptstrFilename, dwHandle, dwLen, lpData);
}

extern "C" BOOL P_GetFileVersionInfoByHandle(
    DWORD dwFlags,
    HANDLE hFile,
    PDWORD pdwLen
) {
    BOOL(*pGetFileVersionInfoByHandle)(DWORD, HANDLE, PDWORD) = (BOOL(*)(DWORD, HANDLE, PDWORD)) (GetVersionFuncAddress("GetFileVersionInfoByHandle"));
    return pGetFileVersionInfoByHandle(dwFlags, hFile, pdwLen);
}

extern "C" BOOL P_GetFileVersionInfoExA(
    DWORD dwFlags,
    LPCSTR lpwstrFilename,
    DWORD dwHandle,
    DWORD dwLen,
    LPVOID lpData
) {
    BOOL(*pGetFileVersionInfoExA)(DWORD, LPCSTR, DWORD, DWORD, LPVOID) = (BOOL(*)(DWORD, LPCSTR, DWORD, DWORD, LPVOID)) (GetVersionFuncAddress("GetFileVersionInfoExA"));
    return pGetFileVersionInfoExA(dwFlags, lpwstrFilename, dwHandle, dwLen, lpData);
}

extern "C" BOOL P_GetFileVersionInfoExW(
    DWORD dwFlags,
    LPCWSTR lpwstrFilename,
    DWORD dwHandle,
    DWORD dwLen,
    LPVOID lpData
) {
    BOOL(*pGetFileVersionInfoExW)(DWORD, LPCWSTR, DWORD, DWORD, LPVOID) = (BOOL(*)(DWORD, LPCWSTR, DWORD, DWORD, LPVOID)) (GetVersionFuncAddress("GetFileVersionInfoExW"));
    return pGetFileVersionInfoExW(dwFlags, lpwstrFilename, dwHandle, dwLen, lpData);
}

extern "C" DWORD P_GetFileVersionInfoSizeA(
    LPCSTR lptstrFilename,
    LPDWORD lpdwHandle
) {
    DWORD(*pGetFileVersionInfoSizeA)(LPCSTR, LPDWORD) = (DWORD(*)(LPCSTR, LPDWORD)) (GetVersionFuncAddress("GetFileVersionInfoSizeA"));
    return pGetFileVersionInfoSizeA(lptstrFilename, lpdwHandle);
}

extern "C" DWORD P_GetFileVersionInfoSizeExA(
    DWORD dwFlags,
    LPCSTR lpwstrFilename,
    LPDWORD lpdwHandle
) {
    DWORD(*pGetFileVersionInfoSizeExA)(DWORD, LPCSTR, LPDWORD) = (DWORD(*)(DWORD, LPCSTR, LPDWORD)) (GetVersionFuncAddress("GetFileVersionInfoSizeExA"));
    return pGetFileVersionInfoSizeExA(dwFlags, lpwstrFilename, lpdwHandle);
}

extern "C" DWORD P_GetFileVersionInfoSizeExW(
    DWORD dwFlags,
    LPCWSTR lpwstrFilename,
    LPDWORD lpdwHandle
) {
    DWORD(*pGetFileVersionInfoSizeExW)(DWORD, LPCWSTR, LPDWORD) = (DWORD(*)(DWORD, LPCWSTR, LPDWORD)) (GetVersionFuncAddress("GetFileVersionInfoSizeExW"));
    return pGetFileVersionInfoSizeExW(dwFlags, lpwstrFilename, lpdwHandle);
}

extern "C" DWORD P_GetFileVersionInfoSizeW(
    LPCWSTR lptstrFilename,
    LPDWORD lpdwHandle
) {
    DWORD(*pGetFileVersionInfoSizeW)(LPCWSTR, LPDWORD) = (DWORD(*)(LPCWSTR, LPDWORD)) (GetVersionFuncAddress("GetFileVersionInfoSizeW"));
    return pGetFileVersionInfoSizeW(lptstrFilename, lpdwHandle);
}

extern "C" BOOL P_GetFileVersionInfoW(
    LPCWSTR lptstrFilename,
    DWORD dwHandle,
    DWORD dwLen,
    LPVOID lpData
) {
    BOOL(*pGetFileVersionInfoW)(LPCWSTR, DWORD, DWORD, LPVOID) = (BOOL(*)(LPCWSTR, DWORD, DWORD, LPVOID)) (GetVersionFuncAddress("GetFileVersionInfoW"));
    return pGetFileVersionInfoW(lptstrFilename, dwHandle, dwLen, lpData);
}

extern "C" DWORD P_VerFindFileA(
    DWORD uFlags,
    LPCSTR szFileName,
    LPCSTR szWinDir,
    LPCSTR szAppDir,
    LPSTR szCurDir,
    PUINT puCurDirLen,
    LPSTR szDestDir,
    PUINT puDestDirLen
) {
    DWORD(*pVerFindFileA)(DWORD, LPCSTR, LPCSTR, LPCSTR, LPSTR, PUINT, LPSTR, PUINT) = (DWORD(*)(DWORD, LPCSTR, LPCSTR, LPCSTR, LPSTR, PUINT, LPSTR, PUINT)) (GetVersionFuncAddress("VerFindFileA"));
    return pVerFindFileA(uFlags, szFileName, szWinDir, szAppDir, szCurDir, puCurDirLen, szDestDir, puDestDirLen);
}

extern "C" DWORD P_VerFindFileW(
    DWORD uFlags,
    LPCWSTR szFileName,
    LPCWSTR szWinDir,
    LPCWSTR szAppDir,
    LPWSTR szCurDir,
    PUINT puCurDirLen,
    LPWSTR szDestDir,
    PUINT puDestDirLen
) {
    DWORD(*pVerFindFileW)(DWORD, LPCWSTR, LPCWSTR, LPCWSTR, LPWSTR, PUINT, LPWSTR, PUINT) = (DWORD(*)(DWORD, LPCWSTR, LPCWSTR, LPCWSTR, LPWSTR, PUINT, LPWSTR, PUINT)) (GetVersionFuncAddress("VerFindFileW"));
    return pVerFindFileW(uFlags, szFileName, szWinDir, szAppDir, szCurDir, puCurDirLen, szDestDir, puDestDirLen);
}

extern "C" DWORD P_VerInstallFileA(
    DWORD uFlags,
    LPCSTR szSrcFileName,
    LPCSTR szDestFileName,
    LPCSTR szSrcDir,
    LPCSTR szDestDir,
    LPCSTR szCurDir,
    LPSTR szTmpFile,
    PUINT puTmpFileLen
) {
    DWORD(*pVerInstallFileA)(DWORD, LPCSTR, LPCSTR, LPCSTR, LPCSTR, LPCSTR, LPSTR, PUINT) = (DWORD(*)(DWORD, LPCSTR, LPCSTR, LPCSTR, LPCSTR, LPCSTR, LPSTR, PUINT)) (GetVersionFuncAddress("VerInstallFileA"));
    return pVerInstallFileA(uFlags, szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir, szTmpFile, puTmpFileLen);
}

extern "C" DWORD P_VerInstallFileW(
    DWORD uFlags,
    LPCWSTR szSrcFileName,
    LPCWSTR szDestFileName,
    LPCWSTR szSrcDir,
    LPCWSTR szDestDir,
    LPCWSTR szCurDir,
    LPWSTR szTmpFile,
    PUINT puTmpFileLen
) {
    DWORD(*pVerInstallFileW)(DWORD, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, LPWSTR, PUINT) = (DWORD(*)(DWORD, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, LPWSTR, PUINT)) (GetVersionFuncAddress("VerInstallFileW"));
    return pVerInstallFileW(uFlags, szSrcFileName, szDestFileName, szSrcDir, szDestDir, szCurDir, szTmpFile, puTmpFileLen);
}

extern "C" DWORD P_VerLanguageNameA(
    DWORD wLang,
    LPSTR szLang,
    DWORD cchLang
) {
    DWORD(*pVerLanguageNameA)(DWORD, LPSTR, DWORD) = (DWORD(*)(DWORD, LPSTR, DWORD)) (GetVersionFuncAddress("VerLanguageNameA"));
    return pVerLanguageNameA(wLang, szLang, cchLang);
}

extern "C" DWORD P_VerLanguageNameW(
    DWORD wLang,
    LPWSTR szLang,
    DWORD cchLang
) {
    DWORD(*pVerLanguageNameW)(DWORD, LPWSTR, DWORD) = (DWORD(*)(DWORD, LPWSTR, DWORD)) (GetVersionFuncAddress("VerLanguageNameW"));
    return pVerLanguageNameW(wLang, szLang, cchLang);
}

extern "C" BOOL P_VerQueryValueA(
    LPCVOID pBlock,
    LPCSTR lpSubBlock,
    LPVOID lplpBuffer,
    PUINT puLen
) {
    BOOL(*pVerQueryValueA)(LPCVOID, LPCSTR, LPVOID, PUINT) = (BOOL(*)(LPCVOID, LPCSTR, LPVOID, PUINT)) (GetVersionFuncAddress("VerQueryValueA"));
    return pVerQueryValueA(pBlock, lpSubBlock, lplpBuffer, puLen);
}

extern "C" BOOL P_VerQueryValueW(
    LPCVOID pBlock,
    LPCWSTR lpSubBlock,
    LPVOID lplpBuffer,
    PUINT puLen
) {
    BOOL(*pVerQueryValueW)(LPCVOID, LPCWSTR, LPVOID, PUINT) = (BOOL(*)(LPCVOID, LPCWSTR, LPVOID, PUINT)) (GetVersionFuncAddress("VerQueryValueW"));
    return pVerQueryValueW(pBlock, lpSubBlock, lplpBuffer, puLen);
}

